
library(tidyverse)
library(haven)
library(broom)
library(patchwork)  
library(ggridges)


# Data Creation -----------------------------------------------------------



setwd("~/Dropbox/IFS Deaton Review/Data/BES_FULL")
#bes <- read_dta("combined.dta")

bes <- read_dta("combined_EDITED.dta")

bes <- bes %>% 
  filter(year!=1963) %>% 
  mutate(homeowner = case_when(housing == 1 ~ 0,
                               housing == 2 ~ 0,
                               housing == 3 ~ 1, 
                               housing %in%c(0, 4) ~ NA_real_,
                               housing74 %in% c(1, 2, 7) ~ 1, 
                               housing74 %in% c(3, 4, 8) ~ 0,
                               housing74 %in% c(0, 9) ~NA_real_,
                               housing79a ==1 ~ 1,
                               housing79a ==2 ~ 0,
                               housing79a %in% c(0, 3, 8) ~ NA_real_,
                               housing83 %in% c(2, 3) ~ 1,
                               housing83 %in% c(4, 5, 6, 7, 97) ~0,
                               housing83 %in% c(1, 98, 99) ~ NA_real_,
                               housing87 %in% c(2, 3) ~ 1,
                               housing87 %in% c(4, 5, 6, 7) ~ 0,
                               housing87 %in% c(1, 97, 99) ~ NA_real_,
                               housing92 %in% c(1) ~ 1,
                               housing92 %in% c(2, 3, 4, 5) ~ 0,
                               housing92 == 9 ~ NA_real_,
                               housing97b %in% c(1) ~ 1,
                               housing97b %in% c(2, 3, 4, 5) ~ 0,
                               housing97b %in% c(-1, 9) ~ NA_real_,
                               housing01a == 1 ~ 1,
                               housing01a == 2 ~ 0,
                               housing01a %in% c(3, 4) ~ NA_real_,
                               housing05a == 1 ~ 1, 
                               housing05a ==2 ~ 0, 
                               housing05a %in% c(3, 99) ~ NA_real_,
                               housing10a == 1 ~ 1, 
                               housing10a ==2 ~ 0, 
                               housing10a %in% c(-2, -1, 3) ~ NA_real_,
                               housing15 %in% c(1, 2) ~ 1,
                               housing15 %in% c(3, 4, 5) ~0,
                               housing15 %in% c(-999, -1) ~ NA_real_,
                               housing17 %in% c(1, 2) ~ 1,
                               housing17 %in% c(3, 4, 5) ~0,
                               housing17 %in% c( -1) ~ NA_real_,
                               housing19 %in% c(1, 2) ~ 1,
                               housing19 %in% c(3, 4, 5) ~0,
                               housing19 %in% c(-999, -1, 6) ~ NA_real_),
         conservative = case_when(party00 == 1 ~ 1,
                                  party00 %in% c(2, 3, 4, 5, 6, 7, 8, 9) ~ 0,
                                  party00 > 9 ~ NA_real_),
         labour = case_when(party00 == 2 ~ 1,
                            party00 %in% c(1, 3, 4, 5, 6, 7, 8, 9) ~ 0,
                            party00 > 9 ~ NA_real_),
         liberal = case_when(party00 == 3 ~ 1,
                             party00 %in% c(1, 2,  4, 5, 6, 7, 8, 9) ~ 0,
                             party00 > 9 ~ NA_real_),
         uppersec = case_when(education==2 ~ 1, 
                            education %in% c(1, 3) ~ 0,
                            TRUE ~ NA_real_),
         primary = case_when(education==1 ~ 1, 
                              education %in% c(2, 3) ~ 0,
                              TRUE ~ NA_real_),
         nosay = 6-uk_nosay)
 
# Homeownership Bivariate -------------------------------------------------


bes_tidy_cons_h <-  bes %>%
  filter(year!=1966) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ homeowner, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


h1 <- bes_tidy_cons_h %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Homeownership (Bivariate) \n (DV Voting Conservative)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  ylim(c(0, 0.35))

ggsave( "bes_homeowner_cons_final.png", h1, width = 6)

bes_tidyturn_h <-  bes %>%
  filter(year!=1966) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ homeowner, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


h2 <- bes_tidyturn_h %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Homeownership (Bivariate) \n (DV Turnout)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_homeowner_turnout_final.png", h2, width = 6)



# # Education Bivariate ---------------------------------------------------


bes_tidy_cons_e <-  bes %>%
  filter(year>1962) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ education, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


e1 <- bes_tidy_cons_e %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Education (Bivariate) \n (DV Voting Conservative)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_education_cons_final.png", e1, width = 6)

bes_tidy_turn_e <-  bes %>%
  filter(year>1962) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ education, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


e2 <- bes_tidy_turn_e %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Education (Bivariate) \n (DV Turnout)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_education_turnout_final.png", e2, width = 6)


# Degree ------------------------------------------------------------------



bes_tidy_cons_d1 <-  bes %>%
  filter(year>1962) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ uppersec+degree, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))

d1 <- bes_tidy_cons_d1 %>% 
  filter(term=="degree") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Degree (Bivariate) \n (DV Voting Conservative)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_degree_cons.png", d1)

u1 <- bes_tidy_cons_d1 %>% 
  filter(term=="uppersec") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Upper Secondary (Bivariate) \n (DV Voting Conservative)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_uppersec_cons.png", u1)



bes_tidy_turnout_d1 <-  bes %>%
  filter(year>1962) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ uppersec+degree, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))

d2 <- bes_tidy_turnout_d1 %>% 
  filter(term=="degree") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Degree (Bivariate) \n (DV Turnout)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_degree_turnout.png", d2)

u2 <- bes_tidy_turnout_d1 %>% 
  filter(term=="uppersec") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Upper Secondary (Bivariate) \n (DV Turnout)")+
  geom_hline(yintercept = 0, linetype = "dotted" )+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))

ggsave("bes_uppersec_turnout.png", u2)
# Age bivariate ----------------------------------------------------



bes_tidy_cons_a <-  bes %>%
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ age, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


a1 <- bes_tidy_cons_a %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Age (Bivariate) \n (DV Voting Conservative)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_age_cons_final.png", a1, width = 6)

bes_tidy_turn_a <-  bes %>%
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ age, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


a2 <- bes_tidy_turn_a %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Age (Bivariate) \n (DV Turnout)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_age_turnout_final.png", a2, width = 6)

# Gender bivariate ----------------------------------------------------



bes_tidy_cons_g <-  bes %>%
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ sex, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


g1 <- bes_tidy_cons_g %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Female (Bivariate) \n (DV Voting Conservative)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_gender_cons.png", g1)

bes_tidy_turn_g <-  bes %>%
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ sex, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


g2 <- bes_tidy_turn_g %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Female (Bivariate) \n (DV Turnout)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_gender_turnout.png", g2)


# Income bivariate ----------------------------------------------------



bes_tidy_cons_i <-  bes %>%
  filter(year!=1983) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ income, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


i1 <- bes_tidy_cons_i %>% 
  filter(term=="income") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Income (Bivariate) \n (DV Voting Conservative)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_income_cons_final.png", i1, width = 6)

bes_tidy_turn_i <-  bes %>%
  filter(year!=1983) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ income, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


i2 <- bes_tidy_turn_i %>% 
  filter(term=="income") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Income (Bivariate) \n (DV Turnout)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept = 0, linetype = "dotted" )

ggsave("bes_income_turnout_final.png", i2, width = 6)




# Multivariate Analyses Excluding 1966 and Income --------------------------------------------------


bes_tidy_cons_m <-  bes %>%
  filter(year!=1966) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ homeowner+age+education+sex, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-c(data, fit))


mh <- bes_tidy_cons_m %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  xlab("Year")+ ylab("Coefficient on Homeownership (Multivariate) \n (DV Voting Conservative)")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  ylim(c(0, 0.35))

ggsave("bes_homeowner_cons_multi.png", mh)

me <- bes_tidy_cons_m %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Education (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_education_cons_multi.png", me)

ma <- bes_tidy_cons_m %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Age (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_age_cons_multi.png", ma)

mg <- bes_tidy_cons_m %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Female (Multivariate) \n (DV Voting Conservative)")+  
  geom_hline(yintercept=0, linetype = "dotted")

ggsave("bes_sex_cons_multi.png", mg)

p1 <- (mh+me)/(ma+mg)
ggsave("bes_cons_multi.png", p1, width = 10, height =7.5)

bes_tidy_turn_m <-  bes %>%
  filter(year!=1966) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ homeowner+age+education+sex, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>%  
  select(-c(data, fit))


mth <- bes_tidy_turn_m %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Homeownership (Multivariate)\n (DV Turnout)")+
  geom_hline(yintercept=0, linetype = "dotted")

ggsave("bes_homeowner_turnout_multi.png", mth)

mte <- bes_tidy_turn_m %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Education (Multivariate)\n (DV Turnout)")+
  geom_hline(yintercept=0, linetype = "dotted")

ggsave("bes_education_turnout_multi.png", mte)

mtg <- bes_tidy_turn_m %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Female (Multivariate)\n (DV Turnout)")+
  geom_hline(yintercept=0, linetype = "dotted")

ggsave("bes_gender_turnout_multi.png", mtg)

mta <- bes_tidy_turn_m %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
   scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Age (Multivariate)\n (DV Turnout)")+
  geom_hline(yintercept=0, linetype = "dotted")

ggsave("bes_age_turnout_multi.png", mta)

p2 <- (mth+mte)/(mta+mtg)
ggsave("bes_turnout_multi.png", p2, width = 10, height =7.5)

# Multivariate Analyses Excluding 1966 and 1983 --------------------------------------------------


bes_tidy_cons_m2 <-  bes %>%
  filter(year!=1966 & year!=1983) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ homeowner+age+education+sex+income, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-data)


mh2 <- bes_tidy_cons_m2 %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Homeownership (Multivariate) \n (DV Voting Conservative)")+
  ylim(c(0, 0.35))

ggsave("bes_homeowner_cons_multi2.png", mh2)

me2 <- bes_tidy_cons_m2 %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Education (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_education_cons_multi2.png", me2)

ma2 <- bes_tidy_cons_m2 %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Age (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_age_cons_multi2.png", ma2)

mg2 <- bes_tidy_cons_m2 %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Female (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_gender_cons_multi2.png", mg2)

mi2 <- bes_tidy_cons_m2 %>% 
  filter(term=="income") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Income (Multivariate) \n (DV Voting Conservative)")

ggsave("bes_income_cons_multi2.png", mi2)

p3 <- mh2+me2+ma2+mg2+mi2+plot_layout(ncol=3)
ggsave("bes_cons_multi2.png", p3, width = 12, height =7.5)

bes_tidy_turn_m2 <-  bes %>%
  filter(year!=1966 & year!=1983) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(voted ~ homeowner+age+education+sex+income, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>%  
  select(-data)


mth2 <- bes_tidy_turn_m2 %>% 
  filter(term=="homeowner") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Homeownership (Multivariate)\n (DV Turnout)")

ggsave("bes_homeowner_turnout_multi2.png", mth2)

mte2 <- bes_tidy_turn_m2 %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Education (Multivariate)\n (DV Turnout)")

ggsave("bes_education_turnout_multi2.png", mte2)

mta2 <- bes_tidy_turn_m2 %>% 
  filter(term=="age") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Age (Multivariate)\n (DV Turnout)")

ggsave("bes_age_turnout_multi2.png", mta2)

mtg2 <- bes_tidy_turn_m2 %>% 
  filter(term=="sex") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Female (Multivariate)\n (DV Turnout)")

ggsave("bes_gender_turnout_multi2.png", mtg2)

mti2 <- bes_tidy_turn_m2 %>% 
  filter(term=="income") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Income (Multivariate)\n (DV Turnout)")

ggsave("bes_income_turnout_multi2.png", mti2)


p4 <- mth2+mte2+mta2+mtg2+mti2+plot_layout(ncol=3)
ggsave("bes_turnout_multi2.png", p4, width = 12, height =7.5)

# People have no say - 5 is Strongly Agree

bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  group_by(year) %>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1))

biv <- bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  group_by(year) %>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1)) %>% 
  ggplot(aes(x = year, y = mean_nosay))+
  geom_line()+geom_point()+
  theme_classic()+
  ylab("% Agreeing 'People Like Me Have No Say'")+
  xlab("General Election Year")+
  ylim(c(0.25, 0.75))

a <- bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  filter(!is.na(education)) %>% 
  mutate(ed_type = case_when(education==1 ~ "Below Secondary",
                             education==2 ~ "Secondary",
                             education==3 ~ "University Degree",
                             TRUE ~ NA_character_)) %>% 
  group_by(year, ed_type) %>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1)) %>% 
  ggplot(aes(x = year, y = mean_nosay, group = ed_type, color=ed_type))+
  geom_line()+geom_point()+
  theme_classic()+
  ylab("% Agreeing 'People Like Me Have No Say'")+
  xlab("General Election Year")+
  theme(legend.title = element_blank())+
  scale_color_manual(values = c("gray85", "gray50", "black"))+
  ylim(c(0.23, 0.75))

#ggsave("nosay_education.png")

b <- bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  filter(!is.na(age)) %>% 
  mutate(over_fifty = case_when(age<=50 ~ "Under 50",
                             age > 50 ~ "Over 50",
                             TRUE ~ NA_character_)) %>% 
  group_by(year, over_fifty) %>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1)) %>% 
  ggplot(aes(x = year, y = mean_nosay, group = over_fifty, color=over_fifty))+
  geom_line()+geom_point()+
  theme_classic()+
  ylab("% Agreeing 'People Like Me Have No Say'")+
  xlab("General Election Year")+
  theme(legend.title = element_blank())+
  scale_color_manual(values = c("grey", "black"))+
  ylim(c(0.23, 0.75))

#ggsave("nosay_over_fifty.png")

c <- bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  filter(!is.na(homeowner)) %>% 
  mutate(owner = case_when(homeowner==1 ~ "Owns Home",
                                homeowner==0 ~ "Doesn't Own Home",
                                TRUE ~ NA_character_)) %>% 
  group_by(year, owner) %>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1)) %>% 
  ggplot(aes(x = year, y = mean_nosay, group = owner, color=owner))+
  geom_line()+geom_point()+
  theme_classic()+
  ylab("% Agreeing 'People Like Me Have No Say'")+
  xlab("General Election Year")+
  theme(legend.title = element_blank())+
  scale_color_manual(values = c("grey", "black"))+
  ylim(c(0.23, 0.75))

#ggsave("nosay_owner.png")

d <- bes %>% 
  filter(!is.na(uk_nosay_bin)) %>% 
  filter(income %in% c(1, 3, 5)) %>% 
  mutate(inc_grp = case_when(income==5 ~ "Top Income",
                           income==3 ~ "Middle Income",
                           income==1 ~ "Bottom Income",
                           TRUE ~ NA_character_)) %>% 
  group_by(year, inc_grp)%>% 
  summarise(mean_nosay = weighted.mean(uk_nosay_bin, weight = sample_weight1)) %>% 
  ggplot(aes(x = year, y = mean_nosay, group = inc_grp, color=inc_grp))+
  geom_line()+geom_point()+
  theme_classic()+
  ylab("% Agreeing 'People Like Me Have No Say'")+
  xlab("General Election Year")+
  theme(legend.title = element_blank())+
  scale_color_manual(values = c("gray85", "gray50", "black"))+
  ylim(c(0.23, 0.75))

#ggsave("nosay_owner.png")

(a+b)/(c+d)

ggsave("nosay.png", width = 10, height = 7)
ggsave("nosay.pdf", width = 10, height = 7)

# Regression Version

bes_nosay_reg <-  bes %>%
  filter(year>1983 & year!=2010) %>% 
  nest(data = -year) %>% 
  mutate(
    fit = map(data, ~ lm(uk_nosay_bin ~ homeowner+age+education+sex+income, data = .x, weight = sample_weight1)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>%  
  select(-c("data","fit"))

bes_nosay_reg %>% 
  filter(term=="education") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  geom_hline(yintercept=0, linetype = "dotted")+
  scale_x_continuous(breaks = c( 1980, 1990, 2000, 2010, 2020))+
  xlab("Year")+ ylab("Coefficient on Education (Multivariate)\n (DV No Say)")


### Regional Data

bes_regional_means <-  bes %>%
  filter(year!=1966 & year!=1983) %>% 
  group_by(nuts1, year) %>% 
  mutate(nuts1 = case_when(nuts1=="UKC" ~"North East",
                           nuts1=="UKD" ~ "North West",
                           nuts1=="UKE" ~ "Yorkshire",
                           nuts1=="UKF" ~ "East Midlands",
                           nuts1=="UKG" ~ "West Midlands",
                           nuts1=="UKH" ~ "East",
                           nuts1=="UKI" ~ "London",
                           nuts1=="UKJ" ~ "South East",
                           nuts1=="UKK" ~ "South West",
                           nuts1=="UKL" ~ "Wales",
                           nuts1=="UKM" ~ "Scotland",
  )) %>% 
  summarise(mean_cons = weighted.mean(conservative, na.rm=T, wt =sample_weight1),
            mean_income =mean(income, na.rm=T, wt =sample_weight1),
            mean_ed = mean(education, na.rm=T, wt =sample_weight1),
            mean_degree = mean(degree, na.rm=T, wt=sample_weight1),
            mean_home = mean(homeowner, na.rm=T, wt =sample_weight1)) %>% 
  filter(nuts1!="" & nuts1!="UK1" & nuts1!="UKN")

bes_regional_means %>% 
  ggplot(aes(x=mean_income, y=mean_cons, label = nuts1))+
  geom_text()+
  geom_smooth(method="lm")+
  facet_wrap(~year)+
  xlim(c(2.0, 3.5))+xlab("Mean Income among Respondents")+ylab("Mean Conservative Vote among Respondents")+
  theme_classic()

bes_regional_means %>% 
  ggplot(aes(x=mean_ed, y=mean_cons, label = nuts1))+
  geom_text()+
  geom_smooth(method="lm")+
  xlim(c(0.8, 2.4))+
  facet_wrap(~year)+
  xlab("Mean Education among Respondents")+ylab("Mean Conservative Vote among Respondents")+
  theme_classic()

bes_regional_means %>% 
  ggplot(aes(x=mean_degree, y=mean_cons, label = nuts1))+
  geom_text()+
  geom_smooth(method="lm")+
  xlim(c(0, 0.4))+
  facet_wrap(~year)+
  xlab("Mean Degree-Holder among Respondents")+ylab("Mean Conservative Vote among Respondents")+
  theme_classic()

bes_regional_means %>% 
  ggplot(aes(x=mean_home, y=mean_cons, label = nuts1))+
  geom_text()+
  geom_smooth(method="lm")+
  facet_wrap(~year)+
  xlab("Mean Homeowner among Respondents")+ylab("Mean Conservative Vote among Respondents")+
  theme_classic()



bes_tidy_cons_regions <-  bes %>%
  filter(year!=1966 & year!=1983) %>% 
  nest(-nuts1, -year) %>% 
  mutate(
    fit = map(data, ~ lm(conservative ~ homeowner+age+education+sex+income, data = .x)),
    tidied = map(fit, tidy)
  ) %>% 
  unnest(tidied) %>% 
  select(-data, -fit)

mi2 <- bes_tidy_cons_regions %>% 
  filter(term=="income", nuts1!="UKN", nuts1!="", nuts1!="UK1") %>% 
  ggplot(aes(x = year, y=estimate, ymax = estimate+1.96*std.error, ymin = estimate-1.96*std.error))+
  geom_pointrange() +
  theme_classic() +
  facet_wrap(~nuts1)+
  scale_x_continuous(breaks = c(1960, 1970, 1980, 1990, 2000, 2010, 2020))+
  geom_hline(yintercept=0, linetype = "dotted")+
  xlab("Year")+ ylab("Coefficient on Income (Multivariate) \n (DV Voting Conservative)")